import { View, Text, FlatList, Pressable } from "react-native";
import React, { useState, useEffect } from "react";
import { allCategoriesStyle } from "./categoriesStyle";
import ProgressiveImage from "../../src/components/ProgressiveImage";
import DownIcon from "../../assets/svgs/dropdown/down.svg";
import UpIcon from "../../assets/svgs/dropdown/up.svg";
import { queryResponse } from "../../redux/slices/util/processResponse.js";
import SubCategory from "./SubCategory";
import { useNavigation } from "@react-navigation/native";
import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../hooks/useLangTranslation";
import CustomSVG from "../../src/components/CustomSVG/CustomSVG";

const SingleCategory = ({ item, showSubCategory, setShowSubCategory }) => {
    const navigation = useNavigation();
    const [subCategory, setSubCategory] = useState([]);
    useEffect(() => {
        (async () => {
            let isMounted = true;
            if (isMounted) {
                const subCategoryUrl = `${BASE_API_URL_STG}/user/categories/sub-category/${item?.id}?status=Active`;
                const response = await queryResponse(subCategoryUrl);
                const { status, records = {} } = response || {};
                if (status?.code == 200 && records?.data?.length > 0) {
                    let newData = [];
                    for (let item of records?.data) {
                        newData = [...newData, { id: item?.id, name: item?.name, slug: item?.slug }];
                    }
                    setSubCategory(newData);
                }
            }
            return () => {
                isMounted = false;
            };
        })()
    }, []);
    const handleShowSubCategory = (id) => {
        setShowSubCategory({
            id: id,
            show: true,
        });
    };
    const handleHideSubCategory = (id) => {
        setShowSubCategory({
            id: id,
            show: false,
        });
    };

    const handleViewCategory = () => {
        const categoryProductUrl = `${BASE_API_URL_STG}/user/products?categories=${item?.slug}`;
        navigation.navigate("feature display", {
            name: item.name,
            url: categoryProductUrl,
        });
    };

    const SubCategoryBtn = () => {
        const { trans } = useLangTranslation();
        return (
            <Text
                style={allCategoriesStyle.subCategories(subCategory?.length)}
            >
                {trans("Sub Categories")}
            </Text>
        );
    };

    return (
        <View
            style={allCategoriesStyle.singleCtgContainer}
        >
            <View style={allCategoriesStyle.item}>
                <Pressable
                    onPress={handleViewCategory}
                    style={allCategoriesStyle.imageContainer}
                >
                    <ProgressiveImage
                        source={{ uri: item.picture_url }}
                        style={allCategoriesStyle.image}
                    />
                </Pressable>
                <View style={allCategoriesStyle.categoryView}>
                    <Pressable onPress={handleViewCategory}>
                        <Text style={allCategoriesStyle.categoryName}>
                            {item.name}
                        </Text>
                    </Pressable>
                    <View style={allCategoriesStyle.subCategoryContainer}>
                        {showSubCategory.id === item.id &&
                        showSubCategory.show ? (
                            <Pressable
                                onPress={() => handleHideSubCategory(item.id)}
                                style={allCategoriesStyle.dropdownIcon}
                            >
                                <SubCategoryBtn />
                                <CustomSVG svgIcon={UpIcon} />
                            </Pressable>
                        ) : (
                            <Pressable
                                disabled={
                                    subCategory?.length == 0 ? true : false
                                }
                                onPress={() => handleShowSubCategory(item.id)}
                                style={allCategoriesStyle.dropdownIcon}
                            >
                                <SubCategoryBtn />
                                <CustomSVG svgIcon={DownIcon}
                                    fill={
                                        subCategory?.length == 0
                                            ? "#DFDFDF"
                                            : "#898989"
                                    }
                                />
                            </Pressable>
                        )}
                    </View>
                </View>
            </View>
            {showSubCategory.id === item.id &&
                showSubCategory.show &&
                subCategory?.length > 0 && (
                    <View style={allCategoriesStyle.item}>
                        <View
                            style={[
                                allCategoriesStyle.imageContainer,
                                allCategoriesStyle.borderWidth0,
                            ]}
                        />

                        <View
                            style={[
                                allCategoriesStyle.categoryView,
                                allCategoriesStyle.subCategoryMenu,
                            ]}
                        >
                            <FlatList
                                data={subCategory}
                                keyExtractor={(item) => item.id}
                                renderItem={({ item, index }) => (
                                    <SubCategory
                                        item={item}
                                        index={index}
                                        dataLength={subCategory?.length}
                                    />
                                )}
                            />
                        </View>
                    </View>
                )}
        </View>
    );
};

export default SingleCategory;
